/*
 * SPDX-License-Identifier: CC0-1.0
 * SPDX-URL: https://spdx.org/licenses/CC0-1.0.html
 *
 * Copyright (C) 2009 Daniel J. Bernstein <djb@cr.yp.to>
 *
 * X25519 ECDH test vectors.
 *
 * These were taken from [1], but with the secret key octets clamped as
 * described in [2]. They are also located in Section 6.1 of RFC7748 [3].
 *
 * [1] <https://cr.yp.to/highspeed/naclcrypto-20090310.pdf>
 * [2] <https://cr.yp.to/ecdh.html>
 * [3] <https://tools.ietf.org/html/rfc7748#section-6.1>
 */

#ifndef ATHEME_MOD_SASL_ECDH_X25519_CHALLENGE_VECTORS_H
#define ATHEME_MOD_SASL_ECDH_X25519_CHALLENGE_VECTORS_H 1

static const unsigned char ecdh_x25519_alice_sk[] = {
	0x70U, 0x07U, 0x6DU, 0x0AU, 0x73U, 0x18U, 0xA5U, 0x7DU,
	0x3CU, 0x16U, 0xC1U, 0x72U, 0x51U, 0xB2U, 0x66U, 0x45U,
	0xDFU, 0x4CU, 0x2FU, 0x87U, 0xEBU, 0xC0U, 0x99U, 0x2AU,
	0xB1U, 0x77U, 0xFBU, 0xA5U, 0x1DU, 0xB9U, 0x2CU, 0x6AU,
};

static const unsigned char ecdh_x25519_alice_pk[] = {
	0x85U, 0x20U, 0xF0U, 0x09U, 0x89U, 0x30U, 0xA7U, 0x54U,
	0x74U, 0x8BU, 0x7DU, 0xDCU, 0xB4U, 0x3EU, 0xF7U, 0x5AU,
	0x0DU, 0xBFU, 0x3AU, 0x0DU, 0x26U, 0x38U, 0x1AU, 0xF4U,
	0xEBU, 0xA4U, 0xA9U, 0x8EU, 0xAAU, 0x9BU, 0x4EU, 0x6AU,
};

static const unsigned char ecdh_x25519_bob_sk[] = {
	0x58U, 0xABU, 0x08U, 0x7EU, 0x62U, 0x4AU, 0x8AU, 0x4BU,
	0x79U, 0xE1U, 0x7FU, 0x8BU, 0x83U, 0x80U, 0x0EU, 0xE6U,
	0x6FU, 0x3BU, 0xB1U, 0x29U, 0x26U, 0x18U, 0xB6U, 0xFDU,
	0x1CU, 0x2FU, 0x8BU, 0x27U, 0xFFU, 0x88U, 0xE0U, 0xEBU,
};

static const unsigned char ecdh_x25519_bob_pk[] = {
	0xDEU, 0x9EU, 0xDBU, 0x7DU, 0x7BU, 0x7DU, 0xC1U, 0xB4U,
	0xD3U, 0x5BU, 0x61U, 0xC2U, 0xECU, 0xE4U, 0x35U, 0x37U,
	0x3FU, 0x83U, 0x43U, 0xC8U, 0x5BU, 0x78U, 0x67U, 0x4DU,
	0xADU, 0xFCU, 0x7EU, 0x14U, 0x6FU, 0x88U, 0x2BU, 0x4FU,
};

static const unsigned char ecdh_x25519_secret[] = {
	0x4AU, 0x5DU, 0x9DU, 0x5BU, 0xA4U, 0xCEU, 0x2DU, 0xE1U,
	0x72U, 0x8EU, 0x3BU, 0xF4U, 0x80U, 0x35U, 0x0FU, 0x25U,
	0xE0U, 0x7EU, 0x21U, 0xC9U, 0x47U, 0xD1U, 0x9EU, 0x33U,
	0x76U, 0xF0U, 0x9BU, 0x3CU, 0x1EU, 0x16U, 0x17U, 0x42U,
};

#endif /* ! ATHEME_MOD_SASL_ECDH_X25519_CHALLENGE_VECTORS_H */
