# frozen_string_literal: true

Gem::Specification.new do |spec|
  spec.name = "spoolinger"
  spec.version = "0.3.2"
  spec.summary = "Spool Manager"
  spec.description = <<~DESC
    The Spoolinger is a generic spool manager, watching
    for incoming files in a specific directory and scheduling
    their processing.
  DESC
  spec.authors = ["Marc Dequènes (Duck)"]
  spec.email = "Duck@DuckCorp.org"
  spec.license = "GPL-3.0-or-later"
  spec.homepage = "https://projects.duckcorp.org/projects/spoolinger/wiki"
  spec.files = Dir["README", "README.config", "CHANGES.md", "lib/**/*", "bin/*", "data/**/*", "examples/**/*", "Gemfile"]
  spec.executables << 'spoolinger'
  spec.executables << 'spoolinger_daemon'
  spec.required_ruby_version = '>= 1.9.0'
  # TODO: convert to md and use a filter for md and txt
  spec.extra_rdoc_files = Dir["README", "README.config", "CHANGES.md"]

  spec.add_runtime_dependency 'log4r' , '~> 1.1.10'
  spec.add_runtime_dependency 'daemons' , '~> 1.1.9'
  spec.add_runtime_dependency 'eventmachine' , '~> 1.0.7'
  spec.add_runtime_dependency 'activesupport' , '~> 5.2.2.1'
  spec.add_runtime_dependency 'rb-inotify' , '~> 0.9.10'
  spec.add_runtime_dependency 'kwalify', '~> 0.7.2'
end
